<?php

// Don't access this directly, please
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Define the settings page.
 *
 * @since 0.1
 */
function emav_settings_page() { ?>

	<div class="wrap">
		<div class="emav-options-column1">
			<div class="headerDiv" >
			<a href="https://5starplugins.com/" target="_blank"><img class="headerImg" src="<?php echo plugin_dir_url(__FILE__) . '../../includes/images/banner.jpg';?>"></a>
		</div>

        <h1 class="header-title"><?php esc_html_e( 'Easy Marijuana Age Verify Settings', 'easy-marijuana-age-verify' ) ?></h1>

		<?php settings_errors(); ?>

		<form action="options.php" method="post" class="emav--settings-form">
			<?php settings_fields( 'easy-marijuana-age-verify' ); ?>
			<?php do_settings_sections( 'easy-marijuana-age-verify' ); ?>

			<?php submit_button(); ?>

			<div class="emav-preview-note">
<?php echo sprintf( __( 'IMPORTANT NOTE: A live preview is currently not available. Refer to our demo screenshots of each "age to verify" to view default messaging shown to visitors.', 'easy-marijuana-age-verify' ));?>
<br/><br/>
<?php echo sprintf( __('TO VIEW YOUR LIVE AGE VERIFY WINDOW: Once you have selected your settings, you will need to "enable verification" to see the pop up on your website. Use a new incognito/private browser window to test the display. Close and open a new incognito/private window for each new test (not tabs). Incognito/private allows display of the verify window to any user (logged in or not) and bypasses saved cookies that are tracking a session or return visit. Age Verify should not be impacted by caching plugins, but you need to clear the page/server/CDN cache upon plugin activation, if it is not displaying, or changes are not reflected on reload.', 'easy-marijuana-age-verify' )); ?>
			<p/></div>

    		<?php 	
			if ( emav_fs()->is_not_paying() ) {
				emav_display_upgrade_btn();
			} ?>
		</form>
	</div>
	<div class="emav-premium-column2">
		<?php
			if ( emav_fs()->is_not_paying() ) {
				echo emav_display_upgrade_features();
			}
		?>
	</div>
			<div class="footer-notes">
				<br/><?php echo sprintf( __( 'Like this? <a href="http://wordpress.org/support/view/plugin-reviews/easy-marijuana-age-verify/?rate=5#new-post"  target="_blank">Share your review</a> so others can benefit.', 'easy-marijuana-age-verify' )); ?>
				<p/><?php echo sprintf( __( 'Having trouble? <a href="https://wordpress.org/plugins/easy-marijuana-age-verify/" target="_blank">View our Free FAQ</a> or <a href="https://wordpress.org/support/plugin/easy-marijuana-age-verify/"  target="_blank">Support Forum</a>.', 'easy-marijuana-age-verify' ) ); ?>
				<p/><?php echo sprintf( __( 'Premium member? Use the <a href="/wp-admin/admin.php?page=easy-marijuana-age-verify-contact">Contact Form</a> for one-on-one tech support. But first, head over to our <a href="https://support.5starplugins.com/collection/47-easy-marijuana-age-gate-plugin" target="_blank">Premium Knowledge Base</a> for fast answers at your fingertips.', 'easy-marijuana-age-verify' )); ?>
				<p/><?php echo sprintf( __( 'Have ideas? <a href="https://wordpress.org/support/plugin/easy-marijuana-age-verify/" target="_blank">Submit a feature request</a>', 'easy-marijuana-age-verify' )); ?>.
				<br />
				<p/><?php echo sprintf( __('Author: <a href="https://5starplugins.com"  target="_blank">5 Star Plugins</a>', 'easy-marijuana-age-verify')); ?>
				<br/><?php echo sprintf( __('Visit Our Partners:<br><a href="https://presswizards.com"  target="_blank">Press Wizards</a>:Worry-free WordPress website hosting and maintenance.', 'easy-marijuana-age-verify')); ?>
				<br/><?php echo sprintf( __('<a href="https://thecannabizagency.com"  target="_blank">The Cannabiz Agency</a>: Expert cannabis web marketing help.', 'easy-marijuana-age-verify')); ?>
			</div>

<?php }

/**********************************************************/
/******************** General Settings ********************/
/**********************************************************/

/**
 * Prints the general settings section heading.
 *
 * @since 0.1
 */
function emav_settings_callback_section_general() {
	// Something should go here
}

/**
 * Prints the modal heading settings field.
 *
 * @since 0.1
 */
function emav_settings_callback_age_header_field() {

	?>
    <input name="_emav_age_header" type="text" id="_emav_age_header" maxlength="50"
           value="<?php echo esc_attr( get_option( '_emav_age_header', __( 'Please verify your age to enter.', 'easy-marijuana-age-verify' ) ) ); ?>"
           class="regular-text"/>

	<?php
}

/**
 * Prints the "require for" settings field.
 *
 * @since 0.2
 */
function emav_settings_callback_require_for_field() { ?>
	<fieldset>
		<legend class="screen-reader-text">
			<span><?php esc_html_e( 'Require verification for', 'easy-marijuana-age-verify' ); ?></span>
		</legend>
		<label>
			<input type="radio" name="_emav_require_for" value="site" <?php checked( 'site', get_option( '_emav_require_for', 'site' ) ); ?>/>
			 <?php esc_html_e( 'Entire site', 'easy-marijuana-age-verify' ); ?><br />
		</label>
		<br />
		<label>
			<input type="radio" name="_emav_require_for" value="content" <?php checked( 'content', get_option( '_emav_require_for', 'site' ) ); ?>/>
			 <?php esc_html_e( 'Specific content', 'easy-marijuana-age-verify' ); ?>
		</label>
	</fieldset>
<?php }

/**
 * Prints the "who to verify" settings field.
 *
 * @since 0.1
 */
function emav_settings_callback_always_verify_field() {
    $option = get_option( '_emav_always_verify' );
    $checked =  checked( 'disabled', $option , false );
    if( ! $option && $option !==  'disabled' )
    {$checked =  checked( 'disabled', $option , false );}
    ?>
	<fieldset>
		<legend class="screen-reader-text">
			<span><?php esc_html_e( 'Enable verification:', 'easy-marijuana-age-verify' ); ?></span>
		</legend>
        <label>
			<input type="radio" name="_emav_always_verify" value="disabled" <?php echo $checked; ?>/>
			 <?php esc_html_e( 'Disable verification to all visitors', 'easy-marijuana-age-verify' ); ?>
		</label>
        <br />
		<label>
			<input type="radio" name="_emav_always_verify" value="guests" <?php checked( 'guests', get_option( '_emav_always_verify', 'guests' ) ); ?>/>
			 <?php esc_html_e( 'Show verification except to logged-in users', 'easy-marijuana-age-verify' ); ?>
		</label>
		<br />
		<label>
			<input type="radio" name="_emav_always_verify" value="all" <?php checked( 'all', get_option( '_emav_always_verify', 'all' ) ); ?>/>
			 <?php esc_html_e( 'Show verification to all visitors', 'easy-marijuana-age-verify' ); ?>
		</label>
	</fieldset>
<?php }
function emav_settings_ask_visitors_fields() {
    return array(
		array(
			'name' => esc_html__( 'Verify 18+ Recreational', 'easy-marijuana-age-verify' ),
			'option' => '',
			'images' => array (
				'free' => '2019/02/Easy-Marijuana-Age-Verify_Free_-18_Recreational.png',
				'premium' => '2019/02/Easy-Marijuana-Age-Verify_Premium_-18_Recreational.png',
			),
		),
		array(
			'name' => esc_html__( 'Verify 19+ Recreational', 'easy-marijuana-age-verify' ),
			'option' => '',
			'images' => array (
				'free' => '2019/02/Easy-Marijuana-Age-Verify_Free_-19_Recreational.png',
				'premium' => '2019/02/Easy-Marijuana-Age-Verify_Premium_-19_Recreational.png',
			),
		),
		array(
			'name' => esc_html__( 'Verify 21+ Recreational', 'easy-marijuana-age-verify' ),
			'option' => '',
			'images' => array (
				'free' => '2019/02/Easy-Marijuana-Age-Verify_Free_-21_Recreational.png',
				'premium' => '2019/02/Easy-Marijuana-Age-Verify_Premium_-21_Recreational.png',
			),
		),
		array(
			'name' => esc_html__( 'Verify 18+ Medical', 'easy-marijuana-age-verify' ),
			'option' => '',
			'images' => array (
				'free' => '2019/10/Easy-Marijuana-Age-Verify_Free_-18_Medical_w-Error.jpg',
				'premium' => '2019/02/Easy-Marijuana-Age-Verify_Premium_-18_Medical.png',
			),
		)
	);
}

function emav_settings_callback_ask_visitors_field() { ?>
	<fieldset class="emav-age-header-option">
		<legend class="screen-reader-text">
			<span><?php esc_html_e( 'Verify the age of:', 'easy-marijuana-age-verify' ); ?></span>
		</legend>
		<label>
			<input type="radio" name="_emav_user_age_verify_option" value="1" <?php checked( '1', get_option( '_emav_user_age_verify_option', '1' ) ); ?>/>
			 <?php esc_html_e( 'Verify 21+ Recreational', 'easy-marijuana-age-verify' ); ?>
		</label> -
        <?php if(!function_exists('emav_premium_verify_option')){
				echo '<a href="https://5starplugins.com/wp-content/uploads/2019/02/Easy-Marijuana-Age-Verify_Free_-21_Recreational.png" class="thickbox">Free Screenshot</a> | ';
				echo '<a href="https://5starplugins.com/wp-content/uploads/2019/02/Easy-Marijuana-Age-Verify_Premium_-21_Recreational.png" class="thickbox">Premium Screenshot</a>';
			} else {
				echo '<a href="https://5starplugins.com/wp-content/uploads/2019/02/Easy-Marijuana-Age-Verify_Premium_-21_Recreational.png" class="thickbox">Premium Screenshot</a>';
			} ?>
        <br />
		<label>
			<input type="radio" name="_emav_user_age_verify_option" value="2" <?php checked( '2', get_option( '_emav_user_age_verify_option', '2' ) ); ?>/>
			 <?php esc_html_e( 'Verify 19+ Recreational', 'easy-marijuana-age-verify' ); ?>
		</label> -
        <?php if(!function_exists('emav_premium_verify_option')){
				echo '<a href="https://5starplugins.com/wp-content/uploads/2019/02/Easy-Marijuana-Age-Verify_Free_-19_Recreational.png" class="thickbox">Free Screenshot</a> | ';
				echo '<a href="https://5starplugins.com/wp-content/uploads/2019/02/Easy-Marijuana-Age-Verify_Premium_19_Recreational.png" class="thickbox">Premium Screenshot</a>';
			} else {
				echo '<a href="https://5starplugins.com/wp-content/uploads/2019/02/Easy-Marijuana-Age-Verify_Premium_19_Recreational.png" class="thickbox">Premium Screenshot</a>';
			} ?>
        <br />
        <label>
			<input type="radio" name="_emav_user_age_verify_option" value="3" <?php checked( '3', get_option( '_emav_user_age_verify_option', '3' ) ); ?>/>
			 <?php esc_html_e( 'Verify 18+ Recreational', 'easy-marijuana-age-verify' ); ?>
		</label> - 
        <?php if(!function_exists('emav_premium_verify_option')){
				echo '<a href="https://5starplugins.com/wp-content/uploads/2019/02/Easy-Marijuana-Age-Verify_Free_-18_Recreational.png" class="thickbox">Free Screenshot</a> | ';
				echo '<a href="https://5starplugins.com/wp-content/uploads/2019/02/Easy-Marijuana-Age-Verify_Premium_-18_Recreational.png" class="thickbox">Premium Screenshot</a>';
			} else {
				echo '<a href="https://5starplugins.com/wp-content/uploads/2019/02/Easy-Marijuana-Age-Verify_Premium_-18_Recreational.png" class="thickbox">Premium Screenshot</a>';
			} ?>
        <br />
        <label>
			<input type="radio" name="_emav_user_age_verify_option" value="4" <?php checked( '4', get_option( '_emav_user_age_verify_option', '4' ) ); ?>/>
			 <?php esc_html_e( 'Verify 18+ Medical', 'easy-marijuana-age-verify' ); ?>
		</label> - 
        <?php if(!function_exists('emav_premium_verify_option')){
				echo '<a href="https://5starplugins.com/wp-content/uploads/2019/10/Easy-Marijuana-Age-Verify_Free_-18_Medical_w-Error.jpg" class="thickbox">Free Screenshot</a> | ';
				echo '<a href="https://5starplugins.com/wp-content/uploads/2019/02/Easy-Marijuana-Age-Verify_Premium_-18_Medical.png" class="thickbox">Premium Screenshot</a>';
			} else {
				echo '<a href="https://5starplugins.com/wp-content/uploads/2019/02/Easy-Marijuana-Age-Verify_Premium_-18_Medical.png" class="thickbox">Premium Screenshot</a>';
			} ?>
		<br />
         <?php
        if(function_exists('emav_premium_verify_option')) {
            echo emav_premium_verify_option();
        } else { ?>
       		<label>
		 		<span style="margin-left: 23px;font-style: italic;"><?php esc_html_e( 'Verify 18+ Medical/21+ Recreational (upgrade to unlock)', 'easy-marijuana-age-verify' ); ?></span>
                </label> - <a href="https://5starplugins.com/wp-content/uploads/2019/02/Easy-Marijuana-Age-Verify_Premium_-21-and-18_Recreational-and-Medical.png"
                class="thickbox">Premium Screenshot</a>
        <?php } ?>
        </fieldset>
    <?php }

/**
 * Prints the minimum age settings field.
 *
 * @since 0.1
 */
function emav_settings_callback_minimum_age_field() { ?>
	
	<input name="_emav_minimum_age" type="number" id="_emav_minimum_age" step="1" min="10" class="small-text" value="<?php echo esc_attr( get_option( '_emav_minimum_age', '21' ) ); ?>" /> <?php esc_html_e( 'years old or older to view this site', 'easy-marijuana-age-verify' ); ?>
	
<?php }

/**
 * Prints the cookie duration settings field.
 *
 * @since 0.1
 */
function emav_settings_callback_cookie_duration_field() { ?>
	
	<input name="_emav_cookie_duration" type="number" id="_emav_cookie_duration" step="15" min="15" class="small-text" value="<?php echo esc_attr( get_option( '_emav_cookie_duration', '720' ) ); ?>" /> <?php esc_html_e( 'minutes', 'easy-marijuana-age-verify' ); ?>
	
<?php }

/**
 * Prints the membership settings field.
 *
 * @since 0.1
 */
function emav_settings_callback_membership_field() { ?>
	
	<fieldset>
		<legend class="screen-reader-text">
			<span><?php esc_html_e( 'Membership', 'easy-marijuana-age-verify' ); ?></span>
		</legend>
		<label for="_emav_membership">
			<input name="_emav_membership" type="checkbox" id="_emav_membership" value="1" <?php checked( 1, get_option( '_emav_membership', 1 ) ); ?>/>
			 <?php esc_html_e( 'Require users to confirm their age before registering to this site', 'easy-marijuana-age-verify' ); ?>
		</label>
	</fieldset>
	
<?php }

/**
 * Prints the modal Disclaimer settings field.
 *
 * @since 0.1
 */
function emav_settings_callback_disclaimer_field() {
    $key = '_emav_disclaimer';
    $text =  __("", 'easy-marijuana-age-verify' );

    if( empty( get_option($key) ) )
        update_option($key,$text);

    $message = esc_attr( get_option( $key, $text) );

    printf('<textarea name="%1$s" id="%1$s" maxlength="250" rows="6" class="regular-text"/>%2$s</textarea>',
        '_emav_disclaimer',
        $message
    );
}


/**********************************************************/
/******************** Display Settings ********************/
/**********************************************************/

/**
 * Prints the display settings section heading.
 *
 * @since 0.1
 */
function emav_settings_callback_section_display() {
	
	//echo '<p>' . esc_html__( 'These settings change the look of your overlay. You can use <code>%s</code> to display the minimum age number from the setting above.', 'easy-marijuana-age-verify' ) . '</p>';
}

/**
 * Prints the input type settings field.
 *
 * @since 0.1
 */
function emav_settings_callback_input_type_field() { ?>
	
	<select name="_emav_input_type" id="_emav_input_type">
		<option value="dropdowns" <?php selected( 'dropdowns', get_option( '_emav_input_type', 'dropdowns' ) ); ?>><?php esc_html_e( 'Date dropdowns', 'easy-marijuana-age-verify' ); ?></option>
		<option value="inputs" <?php selected( 'inputs', get_option( '_emav_input_type', 'dropdowns' ) ); ?>><?php esc_html_e( 'Inputs', 'easy-marijuana-age-verify' ); ?></option>
		<option value="checkbox" <?php selected( 'checkbox', get_option( '_emav_input_type', 'dropdowns' ) ); ?>><?php esc_html_e( 'Confirm checkbox', 'easy-marijuana-age-verify' ); ?></option>
	</select>
	
<?php } ?>